/*
	File: init.sqf
	Author: Loyalguard

	Description:
	init.sqf script for the CEG demo mission.

	Parameters:
	None.
 
	Execution:
	Executed at mission start by the game engine.
*/

// Uncomment this line to disable players from manually switching power on and off through the action menu at substation locations.  True or Nil: enabled.  False: disabled.  Default is enabled.
//CEG_manual = false;

// Uncomment the first line below to allow the CCTV system to use night vision  True: enabled.  False or Nil: disabled.  Default is disabled.  Defaults times for nightvision can also be customized.
//CEG_NVG = true;
//CEG_dark = 19; // Default time Camera NVG use BEGINS, change to customize as desired.  Does not need to be uncommented to work, only if changed.
//CEG_light 6; // Default time Camera NVG use ENDS, change to customize as desired.  Does not need to be uncommented to work, only if changed.

// Uncomment this line to cause an arc flash explosion every time a circuit breaker is switched.  Change the value to whatever odds of occurence you want an arc flash to occur.  For examples CEG_explode = 4 would cause an arc flash 1 in every 4 times, CEG_explode = 100 would cause an arc flash 1 in every 100 times, etc.
//CEG_explode = 1; 

// Comment or delete this line to NOT require a password to logon to the grid control software system.  In the demo a password is required at Elektrozavodsk but NOT at Chernogorsk.
CEG_password = "abc123";

// Display the briefing.
waitUntil {!isNull player};
_nul = [] execVM "briefing.sqf";
_nul = [] execVM "berezinoPowerTask.sqf";

// Show hint.
hint "See briefing notes for more information on the Chernarus Electrical Grid Simulation.  If it is too dark use your NVGs. Logon password is: abc123";

// Debug options for developer only.  Similar code is present in every script.
//CEG_DEBUG = true;
//LGD_fnc_debugMessage = compile (preprocessFileLineNumbers "CEG_DEV\LGD_fnc_debugMessage.sqf"); //DEBUG

if (!isNil "CEG_DEBUG") then {_debug = ["init.sqf: execVM CEG_init.sqf."] call LGD_fnc_debugMessage;}; //DEBUG